/**HEADER********************************************************************
* 
* Copyright (c) 2012 Freescale Semiconductor;
* All Rights Reserved
*
*************************************************************************** 
*
* THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESSED OR 
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
* IN NO EVENT SHALL FREESCALE OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
* INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
* STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
* IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
* THE POSSIBILITY OF SUCH DAMAGE.
*
**************************************************************************
*
* $FileName: bsp_init.c$
* $Version : 1.0.0.0$
* $Date    : Mar-27-2012$
*
* Comments:
*
*   This file contains flash boot code to initialize chip selects,
*   disable the watchdog timer and initialize the PLL.
*
*END************************************************************************/

#include "mqx.h"
#include "bsp.h"
#include "bsp_prv.h"


/***************************************************************************
 * Local Functions Prototypes 
 ***************************************************************************/
/***************************************************************************
 * Local Functions 
 ***************************************************************************/


/***************************************************************************
 * Global Functions 
 ***************************************************************************/
/*FUNCTION*-------------------------------------------------------------------
*
* Function Name    : fxlc95000_init
* Returned Value   : void
* Comments         :
*   Initialize CPU speed and chip selects.  Called from vectors.cw boot
* sequence before calling the runtime application startup code.
*
*END*----------------------------------------------------------------------*/
void fxlc95000_init
   (
      void
   )
{

  // CR ENGR001777877  Dangling QSPI pins at power up
  // Solution is to set QSPI pins as RGPIO inputs.
#define QSPI_PINS (RGPIO_DATA_DATA10_MASK | RGPIO_DATA_DATA11_MASK | RGPIO_DATA_DATA12_MASK | RGPIO_DATA_DATA13_MASK) 
  RGPIO_DIR &= ~QSPI_PINS;  // RGPIOs as inputs 
  RGPIO_ENB |= QSPI_PINS;   // RGPIOs as RGPIO pins

  // See CR ENGR001777877 solution above.
  // Enable SPI.  This is to prevent the PAD inputs from dangling and
  // drawing power.  See Gforge Galla ticket #10284.
  //SPI_SPSCR |= SPI_SPSCR_SPE_MASK;


  
#if (BSP_TIMER == BSP_TIMER_USE_PDB)
  
  // Set FLE, b[4:0], (b[7]=FCEN frame counter enable).
  CK_OSCTRL = 0x80 | BSP_INITIAL_FLE;
#else
  CK_OSCTRL = 0x80;
#endif
  
  // Next frame start with PhiA followed by PhiD.
  //FCSR = 0x20;   // This is the reset default.

  // SCtoFC=1, enable auto slow->fast clk transition from idle to Start Sample Frame
  STOPCR      = 0x01;
}

   


